	PROGRAM TST_GRIEM
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
	IMPLICIT NONE
	INTEGER ND
	INTEGER, PARAMETER :: ND_MAX=5
	INTEGER, PARAMETER :: NFREQ=50
C
	REAL(KIND=LDP) PROF(NFREQ,ND_MAX)
	REAL(KIND=LDP) NU(NFREQ),LAM(NFREQ),LOGLAM(NFREQ)
	REAL(KIND=LDP) ED_IN(ND_MAX),TEMP_IN(ND_MAX),VDOP_IN(ND_MAX)
	REAL(KIND=LDP) Z_IN,AMASS_IN
	INTEGER NL,NUP
C
	INTEGER I
	REAL(KIND=LDP) RYDBERG_HYDROGEN
	EXTERNAL RYDBERG_HYDROGEN
	REAL(KIND=LDP) DEL_NU,T1,RHYD,LAM_ZERO,NU_ZERO
C
	REAL(KIND=LDP) KTH_LAM(17),KTH_GRI(17)
	DATA KTH_LAM/0,0.1_LDP,0.4_LDP,0.8_LDP,1.20_LDP,1.60_LDP,2.0_LDP,2.4_LDP,2.8_LDP,3.2_LDP,3.6_LDP,
	1             4.0_LDP,5.0_LDP,6.0_LDP,7.0_LDP,10.0_LDP,20.0_LDP/
	DATA KTH_GRI/-10.691_LDP,-10.718_LDP,-11.130_LDP,-12.448_LDP,-14.614_LDP,-16.122_LDP,
	1              -16.397_LDP,-16.602_LDP,-16.722_LDP,-16.917_LDP,-17.044_LDP,
	1              -17.158_LDP,-17.396_LDP,-17.590_LDP,-17.754_LDP,
	1              -18.131_LDP,-18.863_LDP/
C
	ED_IN(1:ND_MAX)=10.0_LDP**10
	TEMP_IN(1:ND_MAX)=1.0
!
1000	CONTINUE
	CALL GEN_IN(NL,'NL for species[NL=0 stops program]')
	IF(NL .EQ. 0)STOP
	CALL GEN_IN(NUP,'NUP for species')
	ED_IN(1:ND)=LOG10(ED_IN(1:ND))
	CALL GEN_IN(ED_IN,ND,ND_MAX,'Log10(Electron density[cm^-3])')
	ED_IN(1:ND)=10**(ED_IN(1:ND))
	CALL GEN_IN(TEMP_IN,ND,ND_MAX,'T (10^4) K')
	VDOP_IN(1:ND)=0.0
C
	Z_IN=1.0
	AMASS_IN=1.0
C
	DEL_NU=5.0_LDP/2.998E+05_LDP
	T1=1.1
	NU(1)=0.0
	DO I=2,NFREQ
	  DEL_NU=DEL_NU*T1
	  NU(I)=NU(I-1)+DEL_NU
	END DO
C
C Convert from FREQ space to Angstroms. DWS is the distnace from
C line center in Angstroms.
C
	RHYD=RYDBERG_HYDROGEN()		!cm^{-1}
	NU_ZERO=RHYD*Z_IN*Z_IN*(NUP-NL)*(NUP+NL)/NUP/NUP/NL/NL	!cm^-1
	LAM_ZERO=1.0E+08_LDP/NU_ZERO				!Angstroms.
	DO I=1,NFREQ
	  LAM(I)=ABS( NU(I)/(1.0_LDP+NU(I)) )*LAM_ZERO
	  IF(LAM(I) .GT. 0)LOGLAM(I)=LOG10(LAM(I))
	END DO
C
	CALL TUNE(1,'SET_GRIEM')
	CALL SET_GRIEM(PROF,NU,NFREQ,
	1               ED_IN,TEMP_IN,VDOP_IN,ND,
	1               NL,NUP,AMASS_IN,Z_IN)
	CALL TUNE(2,'SET_GRIEM')
	CALL TUNE(3,' ')
C
	PROF(1:NFREQ,1:ND)=PROF(1:NFREQ,1:ND)/LOG(10.0_LDP)	!To base 10
	DO I=1,ND
	  CALL DP_CURVE(NFREQ,NU,PROF(1,I))
	END DO
	CALL GRAMON_PGPLOT('\gDV/c','Prof',' ',' ')
	DO I=1,ND
	  CALL DP_CURVE(NFREQ,LAM,PROF(1,I))
	END DO
	CALL GRAMON_PGPLOT('Lam(\A)','Prof',' ',' ')
	DO I=1,ND
	  CALL DP_CURVE(NFREQ-3,LOGLAM(4),PROF(4,I))
	END DO
	CALL GRAMON_PGPLOT('Log \gl(\A)','Prof',' ',' ')
C
	IF(NL .EQ. 2 .AND. NUP .EQ. 3)THEN
	  CALL DP_CURVE(NFREQ,LAM,PROF(1,1))
	  CALL DP_CURVE(17,KTH_LAM,KTH_GRI)
	  CALL GRAMON_PGPLOT('Lam(\gV)','Prof',' ',' ')
	END IF
	GOTO 1000
C
	END
