!
! -----Computes unnormalized voigtn function--i.e. normalized to root pi
!
      FUNCTION VOIGTN(AA,VV)
	USE SET_KIND_MODULE
      IMPLICIT NONE
!
! Altered : 03-Dec-2023 - change continuation character to 1
! Cleaned : 20-Nov-2000
!
      REAL(KIND=LDP) VOIGTN,AA,VV
!
      REAL(KIND=LDP) H(25)
      DATA C1,C2/1.128379167095512_LDP  ,5.64189583547756E-1_LDP/
      SAVE C1,C2
!
      REAL(KIND=LDP) V,V2,V4,V6
      REAL(KIND=LDP) A,A2,A4,A6
      REAL(KIND=LDP) Z,Z2
      REAL(KIND=LDP) X,W
      REAL(KIND=LDP) C1,C2
!
      INTEGER I,J
!
      REAL(KIND=LDP) DAWSON
      EXTERNAL DAWSON
!
      V=ABS(VV)
      A=AA
      V2=V*V
      A2=A*A
      Z=A2+V2
      IF(A .LE. 0.5_LDP  )GOTO 20
      IF(Z .LT. 10._LDP  )GOTO 50
C-----ASYMPTOTIC EXPANSION FOR LARGE MODULUS
   10 Z2=Z*Z
      V4=V2*V2
      V6=V4*V2
      A4=A2*A2
      A6=A4*A2
      VOIGTN=C2*A* (1._LDP  +  ((1.875_LDP  *(7._LDP  *V6-35._LDP  *A2*V4+21._LDP*A4*V2-A6)
     1 /Z2+ 0.75_LDP  *(5._LDP  *V4-10._LDP  *A2*V2+A4))/Z2+1.5_LDP  *V2-0.5_LDP*A2)/Z2)/Z
      RETURN
C-----HARRIS EXPANSION
   20 IF(V .GT. 5._LDP  ) GOTO 10
      W=DAWSON(V)
      H(1)= EXP(-V2)
      H(2)=-C1*(1.0_LDP  -2.0_LDP  *V*W)
      H(3)=(1.0_LDP  -2.0_LDP  *V2)*H(1)
      H(4)=-C1*(2._LDP  *(1._LDP  -V2)/3._LDP  -2._LDP  *V*W*(1._LDP  -2._LDP  *V2/3._LDP  ))
C-----HIGHER TERMS BY RECURSION
      DO 30 I=5,11
         X=I-1
         H(I)= (2.0_LDP *(2.0_LDP*X -3.0_LDP -2.0_LDP*V2) *H(I-2) -4.0_LDP*H(I-4))/(X*(X-1.0_LDP  ))
   30 CONTINUE
      VOIGTN=H(11)
      DO 40 I=1,10
         J=11-I
         VOIGTN=H(J)+A*VOIGTN
   40 CONTINUE
      RETURN
C-----GRONWALL EXPANSION
   50 X=1.0_LDP  /(1.0_LDP  +3.275911E-1_LDP*A)
      H(1)=((((1.061405429_LDP  *X-1.453152027_LDP  )*X+1.421413741_LDP  )*X
     1 -2.84496736E-1_LDP)*X+2.54829592E-1_LDP)*X
      DO 60 I=2,25
         X=I-1
         H(I)=2.0_LDP  *A*(C2-A*H(I-1))/(2.0_LDP  *X-1.0_LDP  )
   60 CONTINUE
      VOIGTN=0.0_LDP
      DO 70 I=1,24
         J=26-I
         X=J-1
         VOIGTN=(VOIGTN+H(J))*V2/X
   70 CONTINUE
      VOIGTN= EXP(-V2)*(VOIGTN+H(1))
      RETURN
      END
!
!-----DAWSON*S INTEGRAL USING ANL ALGORITHM, MATH COMP,1970,171
!
      FUNCTION DAWSON(XX)
	USE SET_KIND_MODULE
      IMPLICIT NONE
!
      REAL(KIND=LDP) DAWSON,XX
      REAL(KIND=LDP) X,U
      REAL(KIND=LDP) UP,DOWN
!
      X=XX
      U=X*X
      IF(X .LT. 5.0_LDP  ) GOTO 10
!-----X GREATER THAN 5
      DAWSON= ((5.0000000167450E-1_LDP+7.4999919056701E-1_LDP/
     1 (-2.5001711668562_LDP  +U-2.4878765880441_LDP  /
     1 (-4.6731202214124_LDP  +U-4.1254406560831_LDP  /
     1 (-1.1195216423662E1_LDP+U))))/U+1.0_LDP  )/(2.0_LDP  *X)
      RETURN
C-----X ON (3.5D0,5.0D0)
   10 IF(X .LT. 3.5_LDP  ) GOTO 20
      DAWSON=(5.00001538408193E-1_LDP +2.49811162845499E-1_LDP/
     1 (-1.53672069271915_LDP  +U-6.53419359860764E-1_LDP/
     1 (-1.77068693717670E1_LDP +U+2.04866410976332E2_LDP/
     1 (7.49584016278357_LDP   +U-2.298758419286_LDP  /
     1 (4.02187490205698E1_LDP+U+2.53388006963558E3_LDP/
     1 (-5.9391591850032E1_LDP+U))))))/X
      RETURN
C-----X ON (2.5,3.5)
   20 IF(X .LT. 2.5_LDP  ) GOTO 30
      DAWSON=(5.0140106611704E-1_LDP+1.8897553014354E-1_LDP/
     1 (-7.4499050579364_LDP  +U+7.0204980729194E1_LDP/
     1 (7.5077816490106_LDP  +U+4.1821806337830E1_LDP/
     1 (-2.6629001073842E1_LDP +U+3.7343084728334E1_LDP/
     1 (3.0984087863402E1_LDP+U+1.2599323546764E3_LDP/
     1 (-4.0847391212716E1_LDP+U))))))/X
      RETURN
C-----X LESS THAN 2.5
   30 UP=(((((U*2.0846835103886E-2_LDP -8.5410681195954E-1_LDP)*U
     1 +5.4616122556699E1_LDP)*U-4.3501160207595E2_LDP)*U
     1 +9.6696398191665E3_LDP)*U-2.9179464300780E4_LDP)*U+2.3156975201341E5_LDP
      DOWN=((((( U+2.9391995612556E1_LDP)*U +4.668490654511E2_LDP
     1 )*U+4.7447098440662E3_LDP)*U+3.1384620138163E4_LDP)*U
     1 +1.2520037031851E5_LDP)*U+2.3156975201425E5_LDP
      DAWSON=X*(UP/DOWN)
      RETURN
      END
