C
C Subroutine to store the density of an element, and its atomic number, in
C matrices for use by GETELEC.
C
	SUBROUTINE ELEC_PREP(SPEC_DENS,AT_NO_VEC,NSPEC,NSPEC_MAX,
	1            POPHYD,AT_NO_HYD,HYD_PRES,ND)
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
	INTEGER NSPEC,NSPEC_MAX,ND
	REAL(KIND=LDP) SPEC_DENS(ND,NSPEC_MAX)
	REAL(KIND=LDP) AT_NO_VEC(NSPEC_MAX*ND)
C
	REAL(KIND=LDP) POPHYD(ND)
	REAL(KIND=LDP) AT_NO_HYD
	LOGICAL HYD_PRES
C
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
C
	IF(.NOT. HYD_PRES)RETURN
	NSPEC=NSPEC+1
	IF(NSPEC .GT. NSPEC_MAX)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error in ELEC_PREP'
	  WRITE(LUER,*)'NSPEC_MAX is too small: NSPEC_MAX=',NSPEC_MAX
	  STOP
	END IF
	AT_NO_VEC(NSPEC)=AT_NO_HYD
	SPEC_DENS(:,NSPEC)=POPHYD(:)
C
	RETURN
	END	
