C
C SUBROUTINE TO SOLVE A SYSTEM OF SIMULTANEOUS EQUATIONS IN 'N'
C UNKNOWNS FOR 'NR' RIGHT HAND SIDES USING GUASSIAN ELIMINATION WITH
C PIVOTING. PROGRAM HAS BEAN WRITTEN SO THAT THE (N*N) ARRAY
C IS ACCESSED COLUMN WISE.
C
	SUBROUTINE GAUSEL(A,B,C,N,NR,KS)
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
C Altered 05-Dec-1996 : DO LABEL ... LABEL CONTINUE  changed to DO ... END DO
C                        format (Different DO loops should not end on the
C                        same statement).
C Altered 24-May-1996 : IMPLICIT NONE installed
C
	INTEGER N,NR,KS
	REAL(KIND=LDP) A(N,N),B(N,NR),C(N)
C
	REAL(KIND=LDP), PARAMETER :: TOL=1.0E-30_LDP
C
	INTEGER I,J,L,M,JM
	REAL(KIND=LDP) BIG,RBIG,T1
C
C NOTE THAT C IS A WORKING ARRAY.
C
C
C ENTER MAIN LOOP TO START THE ELIMINATION.
C
	DO 2000 I=1,N-1
C
C FIND MAXIMUM COEFFICIENT IN COLUMN I
C
	BIG=0.0_LDP
	JM=I
	DO 100 J=I,N
	IF(ABS(BIG).LT.ABS(A(J,I)))THEN
				BIG=A(J,I)
				JM=J
		END IF
100	CONTINUE
C
C CHECK THAT PIVOT IS > TOL.
 	IF (ABS(BIG) .LE. TOL)THEN
		KS=1
		RETURN
	END IF
	A(JM,I)=A(I,I)
	RBIG=1.0_LDP/BIG
	A(I,I)=1.0_LDP
C
C STORE COLUMN ELEMENTS
C
	DO 200 J=I+1,N
	C(J)=A(J,I)
200	CONTINUE
C
C PERFORM ELIMINATION FOR EACH COLUMN
C
	DO L=I+1,N
	  T1=A(JM,L)*RBIG
	  A(JM,L)=A(I,L)
	  A(I,L)=T1
	  DO M=I+1,N		
	    A(M,L)=A(M,L)-C(M)*A(I,L)
	  END DO
	END DO
C
C PERFORM ELIMINATION ON THE RIGHT HAND SIDES.
C
	DO L=1,NR
	  T1=B(JM,L)*RBIG
	  B(JM,L)=B(I,L)
	  B(I,L)=T1
	  DO M=I+1,N
	    B(M,L)=B(M,L)-C(M)*B(I,L)
	  END DO
	END DO
C
C
C
2000	CONTINUE
C
C PERFORM BACK SUBSTITUTION.
C
	RBIG=1.0_LDP/A(N,N)
 	DO J=N,2,-1
	  DO L=1,NR
	    IF(J .EQ. N)B(N,L)=B(N,L)*RBIG
	    DO I=J-1,1,-1
	      B(I,L)=B(I,L)-A(I,J)*B(J,L)
	    END DO
	  END DO
	END DO
C
	RETURN
	END
