C
C Function to compute the bound-free gaunt factors for
C a hydrogenic ion of charge Z. The method uses approximate
C formulae which have been fitted to the results of Karasz
C and Latter by Mihalas (Ap. J. ,149,1967, p171) .
C For n> 10 the bound free coefficients are set to unity.
C The frequency should be given in units of 1.0E+15 Hz and the
C temperature in units of 1.0E+04 K .
C
	FUNCTION GBF(RNU,N,ZHE)
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
C Altered 24-May-1996 : IMPLICIT NONE installed.
C                       A now declared REAL(KIND=LDP)
C
	INTEGER N
	REAL(KIND=LDP) GBF,RNU,ZHE
C
	REAL(KIND=LDP) A(0:6,10),T1
	DATA A
	1/  1.2302628_LDP,-2.9094219E-03_LDP,7.3993579E-06_LDP,-8.7356966E-09_LDP
	1, -5.5759888_LDP,12.803223_LDP,0.0_LDP
	1,  1.1595421_LDP,-2.0735860E-03_LDP,2.7033384E-06_LDP,0.0_LDP
	1, -1.2709045_LDP,2.1325684_LDP,-2.0244141_LDP
	1,  1.1450949_LDP,-1.9366592E-03_LDP,2.3572356E-06_LDP,0.0_LDP
	1, -0.55936432_LDP,0.52471924_LDP,-0.23387146_LDP
	1,  1.1306695_LDP,-1.3482273E-03_LDP,-4.6949424E-06_LDP,2.3548636E-08_LDP
	1, -0.31190730_LDP,0.1968356_LDP,-5.4418565E-02_LDP
	1,  1.1190904_LDP,-1.0401085E-03_LDP,-6.9943488E-06_LDP,2.8496742E-08_LDP
	1, -0.16051018_LDP,5.5545091E-02_LDP,-8.9182854E-03_LDP
	1,  1.1168376_LDP,-8.9466573E-04_LDP,-8.8393113E-06_LDP,3.4696768E-08_LDP
	1, -0.13075417_LDP,4.1921183E-02_LDP,-5.5303574E-03_LDP
	1,  1.1128623_LDP,-7.4883260E-04_LDP,-1.0244504E-05_LDP,3.8595771E-08_LDP
	1, -9.5441161E-02_LDP,2.3350812E-02_LDP,-2.2752881E-03_LDP
	1,  1.1093137_LDP,-6.2619148E-04_LDP,-1.1342068E-05_LDP,4.1477731E-08_LDP
	1, -7.1010560E-02_LDP,1.3298411E-02_LDP,-9.7200274E-04_LDP
	1,  1.1078717_LDP,-5.4837392E-04_LDP,-1.2157943E-05_LDP,4.3796716E-08_LDP
	1, -5.6056560E-02_LDP,8.5139736E-03_LDP,-4.9576163E-04_LDP
	1,  1.1052734_LDP,-4.4341570E-04_LDP,-1.3235905E-05_LDP,4.7003140E-08_LDP
	1, -4.7326370E-02_LDP,6.1516856E-03_LDP,-2.9467046E-04_LDP/
C
	T1=RNU/ZHE/ZHE/0.2998_LDP		!To convert from microns to hz
	IF(N .GT. 10 .OR. T1 .GT. 110.0_LDP)THEN
	  GBF=1.0_LDP
	ELSE
	  GBF=A(0,N)+(A(1,N)+(A(2,N)+A(3,N)*T1)*T1)*T1
	1  +(A(4,N)+(A(5,N)+A(6,N)/T1)/T1)/T1
	END IF
C
C
	RETURN
	END
