C
C Function to compute the free-free gaunt factors for a
C hydrogenic ion of charge Z. The gaunt facors are derived
C from a table in ATLAS (1970) which in turn was derived
C from the results of Karzas and Latter. The first 6 values
C for U=0.5 have been correctd by the addition of 0.1 . The
C frequency should be given in units of 1.0E+15 Hz and the
C temperature in units of 1.0E+04 K .
C
	FUNCTION GFF(RNU,T,ZION)
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
C Altered 21-Jun-1998 : E0_DP's inserted.
C Altered 07-Dec-1991 : Ifs replaced by MIN and MAX functions.
C                       GFF_VEC subroutine included.
C
	REAL(KIND=LDP) RNU,T,ZION,GFF
	REAL(KIND=LDP) U,GB,DU,DGB
	INTEGER IU,IGB
C
	REAL(KIND=LDP), SAVE :: A(12,11)
	DATA A
	1/ 5.53_LDP,4.91_LDP,4.29_LDP,3.64_LDP,3.00_LDP,2.41_LDP,1.87_LDP,1.33_LDP,0.90_LDP,0.55_LDP,0.33_LDP,0.19_LDP
	1, 5.49_LDP,4.87_LDP,4.25_LDP,3.61_LDP,2.98_LDP,2.41_LDP,1.89_LDP,1.39_LDP,0.95_LDP,0.59_LDP,0.36_LDP,0.21_LDP
	1, 5.46_LDP,4.84_LDP,4.22_LDP,3.59_LDP,2.97_LDP,2.41_LDP,1.91_LDP,1.44_LDP,1.00_LDP,0.63_LDP,0.39_LDP,0.24_LDP
	1, 5.43_LDP,4.80_LDP,4.18_LDP,3.56_LDP,2.95_LDP,2.41_LDP,1.93_LDP,1.49_LDP,1.08_LDP,0.72_LDP,0.46_LDP,0.28_LDP
	1, 5.40_LDP,4.77_LDP,4.15_LDP,3.54_LDP,2.94_LDP,2.41_LDP,1.95_LDP,1.55_LDP,1.17_LDP,0.86_LDP,0.59_LDP,0.38_LDP
	1, 5.25_LDP,4.63_LDP,4.02_LDP,3.41_LDP,2.81_LDP,2.32_LDP,1.90_LDP,1.56_LDP,1.30_LDP,1.01_LDP,0.76_LDP,0.53_LDP
	1, 5.00_LDP,4.40_LDP,3.80_LDP,3.22_LDP,2.65_LDP,2.19_LDP,1.80_LDP,1.51_LDP,1.32_LDP,1.14_LDP,0.97_LDP,0.76_LDP
	1, 4.69_LDP,4.13_LDP,3.57_LDP,2.97_LDP,2.44_LDP,2.02_LDP,1.68_LDP,1.42_LDP,1.30_LDP,1.18_LDP,1.09_LDP,0.96_LDP
	1, 4.48_LDP,3.87_LDP,3.27_LDP,2.70_LDP,2.21_LDP,1.84_LDP,1.52_LDP,1.33_LDP,1.20_LDP,1.15_LDP,1.13_LDP,1.08_LDP
	1, 4.16_LDP,3.52_LDP,2.98_LDP,2.45_LDP,2.01_LDP,1.67_LDP,1.41_LDP,1.25_LDP,1.15_LDP,1.11_LDP,1.10_LDP,1.09_LDP
	1, 3.85_LDP,3.27_LDP,2.70_LDP,2.20_LDP,1.81_LDP,1.50_LDP,1.30_LDP,1.17_LDP,1.11_LDP,1.08_LDP,1.08_LDP,1.09_LDP/
C
	U=4.7994_LDP; U=LOG10(U*RNU/T)
	U=MAX(-3.99999999_LDP,U)
	U=MIN(1.499999_LDP,U)
	GB=15.789_LDP; GB=LOG10(GB*ZION*ZION/T)
	GB=MAX(-2.99999999_LDP,GB)
	GB=MIN(1.999999_LDP,GB)
	IU=INT(U*2+9.0_LDP)
	IGB=INT(GB*2+7.0_LDP)
	DU=2*U+9.0_LDP-IU
	DGB=2*GB+7.0_LDP-IGB
C
	GFF=((1.0_LDP-DU)*A(IU,IGB)+DU*A(IU+1,IGB))*(1.0_LDP-DGB)
	1 +((1.0_LDP-DU)*A(IU,IGB+1)+DU*A(IU+1,IGB+1))*DGB
C
	RETURN
	END
C
C 
C
	SUBROUTINE GFF_VEC(GFF_VAL,RNU,T,ZION,ND)
	USE SET_KIND_MODULE
	IMPLICIT NONE
	INTEGER ND
	REAL(KIND=LDP) ZION  		!Ion charge
	REAL(KIND=LDP) RNU		!Frequency in units of 10^15 Hz
	REAL(KIND=LDP) T(ND)		!T in units 10^4 K
	REAL(KIND=LDP) GFF_VAL(ND)	!Returned free-free Gaunt factors.
C
C Important data
C
	REAL(KIND=LDP), SAVE :: A(12,11)
	DATA A
	1/ 5.53_LDP,4.91_LDP,4.29_LDP,3.64_LDP,3.00_LDP,2.41_LDP,1.87_LDP,1.33_LDP,0.90_LDP,0.55_LDP,0.33_LDP,0.19_LDP
	1, 5.49_LDP,4.87_LDP,4.25_LDP,3.61_LDP,2.98_LDP,2.41_LDP,1.89_LDP,1.39_LDP,0.95_LDP,0.59_LDP,0.36_LDP,0.21_LDP
	1, 5.46_LDP,4.84_LDP,4.22_LDP,3.59_LDP,2.97_LDP,2.41_LDP,1.91_LDP,1.44_LDP,1.00_LDP,0.63_LDP,0.39_LDP,0.24_LDP
	1, 5.43_LDP,4.80_LDP,4.18_LDP,3.56_LDP,2.95_LDP,2.41_LDP,1.93_LDP,1.49_LDP,1.08_LDP,0.72_LDP,0.46_LDP,0.28_LDP
	1, 5.40_LDP,4.77_LDP,4.15_LDP,3.54_LDP,2.94_LDP,2.41_LDP,1.95_LDP,1.55_LDP,1.17_LDP,0.86_LDP,0.59_LDP,0.38_LDP
	1, 5.25_LDP,4.63_LDP,4.02_LDP,3.41_LDP,2.81_LDP,2.32_LDP,1.90_LDP,1.56_LDP,1.30_LDP,1.01_LDP,0.76_LDP,0.53_LDP
	1, 5.00_LDP,4.40_LDP,3.80_LDP,3.22_LDP,2.65_LDP,2.19_LDP,1.80_LDP,1.51_LDP,1.32_LDP,1.14_LDP,0.97_LDP,0.76_LDP
	1, 4.69_LDP,4.13_LDP,3.57_LDP,2.97_LDP,2.44_LDP,2.02_LDP,1.68_LDP,1.42_LDP,1.30_LDP,1.18_LDP,1.09_LDP,0.96_LDP
	1, 4.48_LDP,3.87_LDP,3.27_LDP,2.70_LDP,2.21_LDP,1.84_LDP,1.52_LDP,1.33_LDP,1.20_LDP,1.15_LDP,1.13_LDP,1.08_LDP
	1, 4.16_LDP,3.52_LDP,2.98_LDP,2.45_LDP,2.01_LDP,1.67_LDP,1.41_LDP,1.25_LDP,1.15_LDP,1.11_LDP,1.10_LDP,1.09_LDP
	1, 3.85_LDP,3.27_LDP,2.70_LDP,2.20_LDP,1.81_LDP,1.50_LDP,1.30_LDP,1.17_LDP,1.11_LDP,1.08_LDP,1.08_LDP,1.09_LDP/
C
C Local Variables.
C
	INTEGER I,IU,IGB
	REAL(KIND=LDP) U,GB,DU,DGB,A1,A2,LOGT
C
	A1=4.7994_LDP; A1=LOG10(A1*RNU)
	A2=15.789_LDP; A2=LOG10(A2*ZION*ZION)
	DO I=1,ND
	  LOGT=LOG10(T(I))
	  U=A1-LOGT
	  U=MAX(-3.99999999_LDP,U)
	  U=MIN(1.499999_LDP,U)
	  GB=A2-LOGT
	  GB=MAX(-2.99999999_LDP,GB)
	  GB=MIN(1.999999_LDP,GB)
	
C
	  IU=INT(U*2+9.0_LDP)
	  IGB=INT(GB*2+7.0_LDP)
	  DU=2*U+9.0_LDP-IU
	  DGB=2*GB+7.0_LDP-IGB
	  GFF_VAL(I)=((1.0_LDP-DU)*A(IU,IGB)+DU*A(IU+1,IGB))*(1.0_LDP-DGB)
	1               +((1.0_LDP-DU)*A(IU,IGB+1)+DU*A(IU+1,IGB+1))*DGB
	END DO
C
	RETURN
	END
