C
C Subroutine to return the Hydrogenic gaunt factors in the COMMON block
C HYDCROSS.
C
C No other action is taken by the routine
C
C Altered 09-May-00 - TMP_HYD inserted to avoid changing to a BLOCK data
C                       subroutine.
C Altered 27-Nov-91 - Changed from function to subroutine.
C Altered 26-Mar-88 - Extended to n=6 although g(5s,5p,6s,6p) set to 1.
C
	SUBROUTINE HYDANGGAUNT
	USE SET_KIND_MODULE
	COMMON /HYDCROSS/ HYD(0:24,1:18)
	REAL(KIND=LDP) HYD
	REAL(KIND=LDP) TMP_HYD(0:24,1:18)
C
C The first 50 elements correspond to 1s and 2s, and are never used
C hence they are set to Zero.
C
	DATA TMP_HYD/50*0.00_LDP,
C 2p
	9    -0.0672_LDP,-0.0672_LDP,-0.0672_LDP,-0.0672_LDP,-0.0673_LDP,-0.0673_LDP,-0.0675_LDP
	9 , -0.0678_LDP,-0.0683_LDP,-0.0693_LDP,-0.0713_LDP,-0.0754_LDP,-0.0842_LDP,-0.1021_LDP
	9 , -0.1366_LDP,-0.1969_LDP,-0.2919_LDP,-0.4271_LDP,-0.6037_LDP,-0.8190_LDP,-1.0681_LDP
	9 , -1.3451_LDP,-1.6449_LDP,-1.9623_LDP,-2.2935_LDP,
C 3s
	9     0.0261_LDP, 0.0263_LDP, 0.0268_LDP, 0.0278_LDP, 0.0297_LDP, 0.0328_LDP, 0.0377_LDP, 0.0464_LDP
	9 , 0.0618_LDP, 0.0873_LDP, 0.1284_LDP, 0.1909_LDP, 0.2774_LDP, 0.3866_LDP, 0.5098_LDP, 0.6331_LDP
	9 , 0.7423_LDP, 0.8265_LDP, 0.8802_LDP, 0.9027_LDP, 0.8963_LDP, 0.8649_LDP, 0.8126_LDP, 0.7438_LDP
	9 , 0.6617_LDP,
C 3p
	9     0.0406_LDP, 0.0408_LDP, 0.0412_LDP, 0.0418_LDP, 0.0428_LDP, 0.0442_LDP, 0.0472_LDP, 0.0524_LDP
	9 , 0.0607_LDP, 0.0745_LDP, 0.0954_LDP, 0.1242_LDP, 0.1568_LDP, 0.1845_LDP, 0.1930_LDP, 0.1671_LDP
	9 , 0.0966_LDP,-0.0230_LDP,-0.1902_LDP,-0.4001_LDP, -0.6461_LDP,-0.9215_LDP,-1.2201_LDP,-1.5371_LDP
	9 ,-1.8681_LDP,
C 3d
	9    -0.1179_LDP,-0.1180_LDP,-0.1181_LDP,-0.1186_LDP,-0.1194_LDP,-0.1207_LDP,-0.1231_LDP,-0.1272_LDP
	9 ,-0.1347_LDP,-0.1479_LDP,-0.1711_LDP,-0.2114_LDP,-0.2795_LDP,-0.3883_LDP,-0.5510_LDP,-0.7764_LDP
	9 ,-1.0674_LDP,-1.4208_LDP,-1.8295_LDP,-2.2850_LDP,-2.7791_LDP,-3.3030_LDP,-3.8512_LDP,-4.4179_LDP
	9 ,-4.9987_LDP,
C 4s
	9    0.0722_LDP, 0.0726_LDP, 0.0734_LDP, 0.0752_LDP, 0.0784_LDP, 0.0836_LDP, 0.0922_LDP, 0.1072_LDP
	9 , 0.1329_LDP, 0.1743_LDP, 0.2374_LDP, 0.3273_LDP, 0.4431_LDP, 0.5790_LDP, 0.7229_LDP, 0.8606_LDP
	9 , 0.9789_LDP, 1.0686_LDP, 1.1259_LDP, 1.1502_LDP, 1.1447_LDP, 1.1139_LDP, 1.0622_LDP, 0.9934_LDP
	9 , 0.9115_LDP,
C 4p
	9    0.0962_LDP, 0.0965_LDP, 0.0971_LDP, 0.0985_LDP, 0.1008_LDP, 0.1047_LDP, 0.1115_LDP, 0.1231_LDP
	9 , 0.1424_LDP, 0.1729_LDP, 0.2169_LDP, 0.2749_LDP, 0.3389_LDP, 0.3952_LDP, 0.4263_LDP, 0.4161_LDP
	9 , 0.3555_LDP, 0.2419_LDP, 0.0783_LDP,-0.1296_LDP,-0.3745_LDP,-0.6492_LDP,-0.9476_LDP,-1.2643_LDP
	9 ,-1.5952_LDP
C 4d
	1 ,0.0535_LDP,0.0537_LDP,0.0539_LDP,0.0542_LDP,0.0548_LDP,0.0559_LDP,0.0577_LDP
	1 ,0.0604_LDP,0.0641_LDP,0.0685_LDP,0.0698_LDP,0.0603_LDP,0.0255_LDP,-0.0530_LDP,-0.1914_LDP
	1 ,-0.3998_LDP,-0.6799_LDP,-1.0266_LDP,-1.4314_LDP,-1.8846_LDP,-2.3773_LDP,-2.9008_LDP
	1 ,-3.4484_LDP,-4.0148_LDP,-4.5953_LDP
C 4f
	1 ,-0.2200_LDP,-0.2222_LDP,-0.2229_LDP,-0.2233_LDP,-0.2250_LDP,-0.2290_LDP,-0.2366_LDP
	1 ,-0.2498_LDP,-0.2729_LDP,-0.3128_LDP,-0.3804_LDP,-0.4908_LDP,-0.6615_LDP,-0.9098_LDP
	1 ,-1.2458_LDP,-1.6720_LDP,-2.1827_LDP,-2.7686_LDP,-3.4167_LDP,-4.1164_LDP,-4.8570_LDP
	1 ,-5.6292_LDP,-6.4264_LDP,-7.2427_LDP,-8.0728_LDP
C 5s
	1 ,25*0.00_LDP
C 5p
	1 ,25*0.00_LDP
C 5d
	1 ,0.1316_LDP,0.1330_LDP,0.1336_LDP,0.1343_LDP,0.1362_LDP,0.1401_LDP,0.1468_LDP,0.1576_LDP
	1 ,0.1738_LDP,0.1956_LDP,0.2196_LDP,0.2353_LDP,0.2242_LDP,0.1647_LDP,0.0400_LDP,-0.1594_LDP
	1 ,-0.4340_LDP,-0.7778_LDP,-1.1804_LDP,-1.6328_LDP,-2.1247_LDP,-2.6478_LDP,-3.1955_LDP
	1 ,-3.7616_LDP,-4.3421_LDP
C 5fg
	1 ,-0.1538_LDP,-0.1557_LDP,-0.1563_LDP,-0.1568_LDP,-0.1584_LDP,-0.1624_LDP,-0.1699_LDP
	1 ,-0.1828_LDP,-0.2055_LDP,-0.2452_LDP,-0.3129_LDP,-0.4240_LDP,-0.5962_LDP,-0.8461_LDP
	1 ,-1.1834_LDP,-1.6105_LDP,-2.1220_LDP,-2.7084_LDP,-3.3568_LDP,-4.0567_LDP,-4.7978_LDP
	1 ,-5.5715_LDP,-6.3499_LDP,-7.2789_LDP,-8.8584_LDP
C 6s
	1 ,25*0.00_LDP
C 6p
	1 ,25*0.00_LDP
C 6d
	1 ,0.1801_LDP,0.1826_LDP,0.1839_LDP,0.1855_LDP,0.1891_LDP,0.1961_LDP,0.2080_LDP,0.2272_LDP
	1 ,0.2562_LDP,0.2952_LDP,0.3390_LDP,0.3741_LDP,0.3795_LDP,0.3326_LDP,0.2163_LDP,0.0219_LDP
	1 ,-0.2497_LDP,-0.5916_LDP,-0.9934_LDP,-1.4450_LDP,-1.9367_LDP,-2.4596_LDP,-3.0070_LDP
	1 ,-3.5734_LDP,-4.1537_LDP
C 6fgh
	1 ,-0.1179_LDP,-0.1201_LDP,-0.1207_LDP,-0.1211_LDP,-0.1227_LDP,-0.1266_LDP,-0.1336_LDP
	1 ,-0.1469_LDP,-0.1698_LDP,-0.2078_LDP,-0.2820_LDP,-0.3663_LDP,-0.5442_LDP,-0.9124_LDP
	1 ,-0.9628_LDP,-2.2915_LDP,-2.0916_LDP,-2.6727_LDP,-3.3259_LDP,-4.0265_LDP
	1 ,-4.7676_LDP,-5.5414_LDP,-6.3198_LDP,-7.2490_LDP,-8.8284_LDP/
C
	HYD=TMP_HYD
C
	END
