C
C File contains physical and astrophysical constants of general interest.
C Each constant can be obtained by a FUNCTION call, and all units are CGS
C unless otherwise is specified in the function name.
C
C Altered 12-Nov-2023: Revised variable declarations to use LDP.
C Altered 22-Sep-2023: Revised physical constants (LONG ver -- 15-Oct-2023).
C Altered 07-Jan-2008: Rsun revised very slightly, TEFF_SUN inserted
C Altered 29-Oct-2007: Stefan Boltzman constant added.
C Altered 29-Apr-1991: ALL routines. REAL(KIND=LDP) now specified in separate
C                      statement for CRAY compatibility.
C Altered 8_Oct-1990 : RYDBERG_CARBON (and NITROGEN) wre returning zero.
C                      IMPLCIT NONE placed in all functions.
C
	FUNCTION SPEED_OF_LIGHT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) SPEED_OF_LIGHT
	SPEED_OF_LIGHT=2.99792458E+10_LDP 			!Exact cm/s
	RETURN
	END

	FUNCTION ELECTRON_VOLT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) ELECTRON_VOLT
	ELECTRON_VOLT=1.602176634E-12_LDP                     !ergs
	RETURN
	END

	FUNCTION GRAVITATIONAL_CONSTANT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) GRAVITATIONAL_CONSTANT
	GRAVITATIONAL_CONSTANT=6.67259E-08_LDP 			!cm^3/gm/s
	RETURN
	END

	FUNCTION PLANCKS_CONSTANT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) PLANCKS_CONSTANT
	PLANCKS_CONSTANT=6.62607015E-27_LDP		!erg sec
	RETURN
	END

	FUNCTION ATOMIC_MASS_UNIT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) ATOMIC_MASS_UNIT
	ATOMIC_MASS_UNIT=1.6605390666E-24_LDP 		!gm
	RETURN
	END

	FUNCTION ELECTRON_MASS()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) ELECTRON_MASS
	ELECTRON_MASS=9.1093837015E-28_LDP 		!gm
	RETURN
	END
!
	FUNCTION ELECTRON_CHARGE()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) ELECTRON_CHARGE
	ELECTRON_CHARGE=4.80320427E-10_LDP              !esu
	RETURN
	END

	FUNCTION BOLTZMANN_CONSTANT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) BOLTZMANN_CONSTANT
	BOLTZMANN_CONSTANT=1.380649E-16_LDP 		!erg/K
	RETURN
	END

	FUNCTION STEFAN_BOLTZ()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) STEFAN_BOLTZ
	STEFAN_BOLTZ=5.670374419E-05_LDP 		!ergs/cm^2/K^4
	RETURN
	END

C 
	FUNCTION RYDBERG_INF()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_INF
	RYDBERG_INF=109737.31534_LDP 			!/cm
	RETURN
	END

	FUNCTION RYDBERG_HYDROGEN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_HYDROGEN
	RYDBERG_HYDROGEN=109677.6_LDP 			!/cm
	RETURN
	END

	FUNCTION RYDBERG_HELIUM()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_HELIUM
	RYDBERG_HELIUM=109722.3_LDP 			!/cm
	RETURN
	END

	FUNCTION RYDBERG_CARBON()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_CARBON
	RYDBERG_CARBON=109732.3_LDP 			!/cm
	RETURN
	END

	FUNCTION RYDBERG_NITROGEN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_NITROGEN
	RYDBERG_NITROGEN=109733.0_LDP 			!/cm
	RETURN
	END

	FUNCTION RYDBERG_OXYGEN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RYDBERG_OXYGEN
	RYDBERG_OXYGEN=109733.5_LDP			!/cm
	RETURN
	END
C 
	FUNCTION MASS_SUN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) MASS_SUN
	MASS_SUN=1.989E+33_LDP 				!gm
	RETURN
	END

	FUNCTION RAD_SUN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) RAD_SUN
	RAD_SUN=6.9599E+10_LDP  		!cm (changed 7-Jan-2008)
	RETURN
	END

	FUNCTION LUM_SUN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) LUM_SUN
	LUM_SUN=3.826E+33_LDP			!erg/s
	RETURN
	END

	FUNCTION TEFF_SUN()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) TEFF_SUN
	TEFF_SUN=5770.0_LDP			!K
	RETURN
	END

	FUNCTION PARSEC()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) PARSEC
	PARSEC=3.0856E+18_LDP   		!cm
	RETURN
	END

	FUNCTION ASTRONOMICAL_UNIT()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) ASTRONOMICAL_UNIT
	ASTRONOMICAL_UNIT=1.49597892E+13_LDP 		!cm
	RETURN
	END

	FUNCTION JANSKY()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) JANSKY
	JANSKY=1.0E-23_LDP 				!ergs/cm^2/s/Hz
	RETURN
	END

	FUNCTION PI()			!Use FUN_PI instead so PI
	USE SET_KIND_MODULE
	IMPLICIT NONE			!can be variable
	REAL(KIND=LDP) PI			!Use FUN_PI instead so PI
	PI=3.141592653589793238462643_LDP
	RETURN
	END
C
	FUNCTION FUN_PI()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) FUN_PI
	FUN_PI=3.141592653589793238462643_LDP
	RETURN
	END

	FUNCTION SECS_IN_YEAR()
	USE SET_KIND_MODULE
	IMPLICIT NONE
	REAL(KIND=LDP) SECS_IN_YEAR
	SECS_IN_YEAR=31557600.0_LDP  	     !365.25*24*60*60
	RETURN
	END
