!
! Subroutine to replace oscilator strength with a value a fator of 1.0E-10 lower.
! Matching is done by level name.
!
! Routine is usefule for testing purposes.
!
	SUBROUTINE SET_GF_VALUES_SMALL(VEC_TRANS_NAME,VEC_OSCIL,VEC_EINA,N_LINE_FREQ,LUIN)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
! Created 21-OCt-2010
! Not tested.
!
	INTEGER N_LINE_FREQ
	INTEGER LUIN
	REAL(KIND=LDP) VEC_OSCIL(N_LINE_FREQ)
	REAL(KIND=LDP) VEC_EINA(N_LINE_FREQ)
	CHARACTER(LEN=*) VEC_TRANS_NAME(N_LINE_FREQ)
!
	REAL(KIND=LDP) WAVE,FREQ,ANG_TO_HZ,T1
	REAL(KIND=LDP) LAM_VAC,SPEED_OF_LIGHT
	CHARACTER(LEN=10) SPECIES,OLD_SPECIES
	CHARACTER(LEN=40) NAME
	CHARACTER(LEN=80) STRING
	INTEGER LUER,ERROR_LU,GET_INDX_DP
	EXTERNAL ERROR_LU,GET_INDX_DP,LAM_VAC,SPEED_OF_LIGHT
!
	INTEGER IOS
	INTEGER J,JST,K,L
!
	LUER=ERROR_LU()
	OPEN(UNIT=LUIN,FILE='LINES_TO_ZERO',STATUS='OLD',IOSTAT=IOS,ACTION='READ')
	IF(IOS .NE. 0)THEN
	  RETURN
	END IF
	WRITE(LUER,'(/,A)')'The following transitions had their "gf" values set to very small values'
!
	OLD_SPECIES='JJJ'
	DO WHILE(1 .EQ. 1)
	  STRING=' '
	  DO WHILE(STRING(1:1) .EQ. '!' .OR. STRING .EQ. ' ')
	    READ(LUIN,'(A)',END=100)STRING
	  END DO
	  STRING=ADJUSTL(STRING)
	  K=INDEX(STRING,'  ')-1
	  NAME=STRING(1:K)
	  L=INDEX(STRING,'(')-1
	  SPECIES=STRING(1:L)
!
	  IF(SPECIES .EQ. OLD_SPECIES)THEN
	  ELSE
	    DO J=1,N_LINE_FREQ
	      IF(SPECIES .EQ. VEC_TRANS_NAME(J)(1:L))THEN
	        JST=J
	        OLD_SPECIES=SPECIES
	        EXIT
	      END IF
	    END DO
	  END IF
!
! Now find the line. These are not ordered.
!
	  DO J=JST,N_LINE_FREQ
	    IF(NAME(1:K) .EQ. VEC_TRANS_NAME(J))THEN
	      VEC_OSCIL(K)=1.0E-10_LDP*VEC_OSCIL(K)
	      VEC_EINA(K)=1.0E-10_LDP*VEC_EINA(K)
	      WRITE(LUER,'(10X,A)')TRIM(VEC_TRANS_NAME(J))
	      EXIT
	    END IF
	  END DO
!
	END DO
!
100	CONTINUE
	CLOSE(LUIN)
!
	RETURN
	END
