	PROGRAM TST_MON
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
C
	INTEGER, PARAMETER :: ND=60
	INTEGER ISEED
C
	REAL(KIND=LDP) R(ND),CHI(ND)
	REAL(KIND=LDP) COEF1(ND,4),COEF2(ND,4)
C
	INTEGER I
C
	ISEED=-1567353
	CALL GEN_IN(ISEED,'Random number initialization')
	DO I=1, 100 ; CHI(1)=RAN(ISEED); END DO
C
	DO I=1,ND
	  R(I)=1.0_LDP+0.1_LDP*(I**2)
	  CHI(I)=RAN(ISEED)
	END DO
C
	CALL MON_INT_FUNS(COEF1,CHI,R,ND)	
	CALL MON_INT_FUNS_V2(COEF2,CHI,R,ND)
C
	OPEN(UNIT=12,FILE='COEF_CHK',RECORDSIZE=132)
	DO I=1,ND
	  WRITE(12,*)(COEF1(I,K),K=1,4)
	END DO
C
	WRITE(12,*)' '
	DO I=1,ND
	  WRITE(12,*)
	1   (200.0_LDP*(COEF1(I,K)-COEF2(I,K))/
	1   (ABS(COEF1(I,K))+ABS(COEF2(I,K))+1.0E-100_LDP), K=1,4)
	END DO
C
	STOP
	END
