	PROGRAM TST_MON
	USE SET_KIND_MODULE
	USE GEN_IN_INTERFACE
C
	INTEGER, PARAMETER :: ND=60
	INTEGER, PARAMETER :: NINS=4
	INTEGER ISEED
C
	REAL(KIND=LDP) R(ND),CHI(ND),dCHIdR(ND)
C
C Be aware that
C
	REAL(KIND=LDP) R_INS(ND-1,NINS),CHI_INS(ND-1,NINS),dCHIdR_INS(ND-1,NINS)
C
	REAL(KIND=LDP) X(NINS*ND),Y(NINS*ND)
C
	LOGICAL LOGX,LOGY,DERIV
C
	INTEGER I
	REAL(KIND=LDP) DELR
	ISEED=-1567353
	CALL GEN_IN(ISEED,'Random number initialization')
	DO I=1, 100 ; CHI(1)=RAN(ISEED); END DO
C
	DO I=1,ND
	  R(I)=1.0_LDP+0.1_LDP*(I**2)
 	  CHI(I)=3.0_LDP*(R(I)/R(1))**4.0
 	  CHI(I)=2.0_LDP+RAN(ISEED)
	END DO
C	DO I=ND,1,-1
C	  R(I)=1.0+0.1D0*((ND-I)**2)
C 	  CHI(I)=3.0*(R(ND)/R(I))**4.0
C 	  CHI(I)=2.0D0+RAN(ISEED)
C	END DO
C
	DO I=1,ND-1
	  DELR=R(I+1)-R(I)
	  R_INS(I,1)=R(I)+0.04_LDP*DELR
	  R_INS(I,2)=R(I)+0.16_LDP*DELR
	  R_INS(I,3)=R(I)+0.40_LDP*DELR
	  R_INS(I,4)=R(I)+0.70_LDP*DELR
	END DO
C
	LOGX=.FALSE.
	LOGY=.FALSE.
	DERIV=.FALSE.
	CALL  MON_INT_INS_V1(CHI_INS,R_INS,NINS,CHI,R,ND,
	1           LOGX,LOGY,dCHIdR,dCHIdR_INS,DERIV)
C
	CALL DP_CURVE(ND,R,CHI)
	J=0
	DO I=1,ND-1
	  DO K=1,NINS
	    J=J+1
	    X(J)=R_INS(I,K)
	    Y(J)=CHI_INS(I,K)
	  END DO
	END DO
	CALL DP_CURVE((ND-1)*NINS,X,Y)
	CALL GRAMON_PGPLOT(' ',' ',' ',' ')
C
	STOP
	END
