	PROGRAM TST_OBS_INS
	IMPLICIT NONE
C
 	INTEGER*4 NCF,NFREQ,N_LINES
	INTEGER*4, PARAMETER :: NCF_MAX=150000
	INTEGER*4, PARAMETER :: N_LINES_MAX=75000
	INTEGER*4, PARAMETER :: NFREQ_MAX=NCF_MAX+N_LINES_MAX
!
! Vecters returned by subroutine:
!
! Line+continuum frequencies
!
	REAL*8 OBS_FREQ(NFREQ_MAX)
	ChARACTER*80 STRING
!
! Passed vectors.
!
	REAL*8 NU_CONT(NCF_MAX)		!Continuum frequencies
	REAL*8 NU_LINE(N_LINES_MAX)		!Line frequencies
	CHARACTER*10 VEC_TRANS_TYPE(N_LINES_MAX)
!
! Passed constants:
!
	REAL*8 VINF		!Terminal velocity of wind.
	REAL*8 V_DOP		!Doppler velocity (km/s).
	REAL*8 FRAC_DOP		!Indicates dNU across line in Doppler widths.
	REAL*8 MAX_DOP		!Half the extent of intrinsic profile
				!  in Doppler widths,
!
	REAL*8 NU_MIN,NU_MIN_OBS
	REAL*8 NU_MAX,NU_MAX_OBS
!
	REAL*8 OBS_PRO_EXT_RAT
        REAL*8 dV_OBS_PROF
	REAL*8 dV_OBS_WING
	REAL*8 dV_OBS_BIG
!
	REAL*8 dV_CMF_PROF
	REAL*8 dV_CMF_WING
	REAL*8 ES_WING_ExT
	REAL*8 R_CMF_WING_EXT
	INTEGER*4 NCF1,N_LINES1
	INTEGER*4 I,ML
	REAL*8 C_KMS
	REAL*8 T1
!
	LOGICAL SOB_FREQ_IN_OBS
!
! External functions
!
	REAL*8 SPEED_OF_LIGHT
	EXTERNAL SPEED_OF_LIGHT
!
	C_KMS=1.0D-05*SPEED_OF_LIGHT()
!
	OPEN(UNIT=10,FILE='CFDAT',STATUS='OLD',READONLY)
	DO ML=1,NCF_MAX
	  READ(10,*,END=100)NU_CONT(ML)
	END DO
100	NCF=ML-1
C
	OPEN(UNIT=10,FILE='LINE',STATUS='OLD',READONLY)
	READ(10,'(A)')STRING
	DO ML=1,N_LINES_MAX
	  READ(10,*,END=200)I,I,I,NU_LINE(ML)
	END DO
200	N_LINES=ML-1
	VEC_TRANS_TYPE(1:N_LINES)='BLANK'
C
	V_DOP=23.0		!km/s
	FRAC_DOP=1.0D0
	MAX_DOP=6.0D0
	VINF=840.0D0		!km/s
C
	dV_CMF_PROF=100.0  		!km/s
	dV_CMF_WING=300.0  		!km/s
	ES_WING_ExT=2500.0  		!km/s
	R_CMF_WING_EXT=3.0D0
!
	SOB_FREQ_IN_OBS=.FALSE.
!
	NU_MIN=0.0014987
	NU_MAX=50.0D0
!
	OBS_PRO_EXT_RAT=1.1
        dV_OBS_PROF=100.0D0		!Km/s
	dV_OBS_WING=400.0D0
	dV_OBS_BIG=2000.0D0
C
	NU_MAX_OBS=NU_CONT(3)		!3 Ensure 
	T1=NU_CONT(NCF)*(1.0+2.0*VINF/2.998D+05)
	NU_MIN_OBS=MAX(NU_CONT(NCF-3),T1)
	CALL INS_LINE_OBS_V3(OBS_FREQ,NFREQ,NFREQ_MAX,
	1               NU_LINE,VEC_TRANS_TYPE,N_LINES,SOB_FREQ_IN_OBS,
	1		NU_MAX_OBS,NU_MIN_OBS,VINF,
	1               dV_OBS_PROF,dV_OBS_WING,dV_OBS_BIG,
	1               OBS_PRO_EXT_RAT,ES_WING_EXT,V_DOP)
!
	WRITE(6,*)NFREQ,OBS_FREQ(NFREQ)
	STOP
	END
