	PROGRAM TST_SET_CONT
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
	INTEGER NFREQ
	INTEGER N_EDGE
	INTEGER, PARAMETER :: NFREQ_MAX=100000
	INTEGER, PARAMETER :: LUOUT=40
!
	REAL(KIND=LDP) FREQ(NFREQ_MAX)			!Continuum frequencies
	REAL(KIND=LDP) EDGE_FREQ(NFREQ_MAX) 		
	CHARACTER*6 EDGE_TYPE(NFREQ_MAX)	!End index for the line
	INTEGER INDX(NFREQ_MAX)
!
	REAL(KIND=LDP) MAX_FREQ
	REAL(KIND=LDP) MIN_FREQ
	REAL(KIND=LDP) SMALL_RAT
	REAL(KIND=LDP) BIG_AMP
	REAL(KIND=LDP) DNU_MAX
	REAL(KIND=LDP) dV_LEV
	REAL(KIND=LDP) AMP_DIS
	REAL(KIND=LDP) MIN_FREQ_LEV_DIS
!
	REAL(KIND=LDP) dV_DOP
	REAL(KIND=LDP) dV_CONT
!
	REAL(KIND=LDP) C_KMS
	REAL(KIND=LDP) SPEED_OF_LIGHT
	EXTERNAL SPEED_OF_LIGHT
!
	INTEGER *4 I,ML
!
	C_KMS=1.0E-05_LDP*SPEED_OF_LIGHT()
!
	OPEN(UNIT=10,FILE='EDGE_FREQ',STATUS='OLD',READONLY)
	ML=0
	DO WHILE(1 .EQ. 1)
	 ML=ML+1
	  READ(10,*,END=100)EDGE_FREQ(ML),EDGE_TYPE(ML)
	  N_EDGE=ML
	END DO
100	CONTINUE
!
	MAX_FREQ=50.0_LDP
	MIN_FREQ=0.003_LDP
!
	SMALL_RAT=1.10_LDP
	BIG_AMP=1.05_LDP
	DNU_MAX=0.1
!
	dV_LEV=200.0_LDP
	AMP_DIS=1.4_LDP
	MIN_FREQ_LEV_DIS=0.1_LDP
	dV_DOP=10.0_LDP
	dV_CONT=1000.0_LDP
!
	EDGE_TYPE(1:N_EDGE)='D'
	CALL SET_CONT_FREQ_V2(FREQ,EDGE_FREQ,EDGE_TYPE,INDX,
	1                        SMALL_RAT,BIG_AMP,DNU_MAX,MAX_FREQ,MIN_FREQ,
	1                        dV_LEV,AMP_DIS,MIN_FREQ_LEV_DIS,
	1                        dV_CONT,dV_DOP,
	1                        N_EDGE,NFREQ,NFREQ_MAX,LUOUT)
C
	WRITE(6,*)'Returned'
	DO ML=1,NFREQ-1
	  WRITE(17,'(I6,2X,3F15.6)')
	1         ML,FREQ(ML), FREQ(ML)-FREQ(ML+1),
	1         C_KMS*(FREQ(ML)-FREQ(ML+1))/FREQ(ML)
	END DO
C
	STOP
	END
