!
! Subroutine to undo corrections from deoths IST to IEND.
!
	SUBROUTINE UNDO_IT(NEW_POPS,POPS,NT,ND,CUR_IT_NO,IST,IEND,AV_DONE)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER NT
	INTEGER ND
	REAL(KIND=LDP) NEW_POPS(NT,ND)
	REAL(KIND=LDP) POPS(NT,ND)
!
	INTEGER CUR_IT_NO
	INTEGER IST
	INTEGER IEND
!
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
	LOGICAL AV_DONE
!
! Local variables
!
	REAL(KIND=LDP) OLD_POPS(NT,ND,2)
	REAL(KIND=LDP) R_TMP(ND)
	REAL(KIND=LDP) V_TMP(ND)
	REAL(KIND=LDP) SIGMA_TMP(ND)
	REAL(KIND=LDP) R
!
	INTEGER I,J
	INTEGER NITSF
	INTEGER IREC
	INTEGER LST_NG
	INTEGER, PARAMETER :: RITE_N_TIMES=1
	INTEGER, PARAMETER :: LUSCR=10
!
	LOGICAL NEWMOD
	LOGICAL WRITE_RVSIG
!
	AV_DONE=.FALSE.
	NEW_POPS=POPS
	IF(CUR_IT_NO .LE. 2)RETURN
	LUER=ERROR_LU()
!
! Read in the last NSTEP estimates of the populations, as output to SCRTEMP.
! NEW_POPS is used for temporary storage.
!
        NEWMOD=.FALSE.
	DO I=CUR_IT_NO-1,CUR_IT_NO
	  IREC=I
          CALL SCR_READ_V2(R_TMP,V_TMP,SIGMA_TMP,NEW_POPS,
	1            IREC,NITSF,RITE_N_TIMES,LST_NG,
	1            WRITE_RVSIG,NT,ND,LUSCR,NEWMOD)
	  IF(I .NE. IREC .OR. NEWMOD)THEN
	    WRITE(LUER,*)'Error reading correct record in SCRTEMP'
	    RETURN
	  END IF
	  OLD_POPS(:,:,1+(CUR_IT_NO-I))=NEW_POPS
	END DO
!
! Undo corrections for depths IST to IEND inclusive.
!
	NEW_POPS=POPS
	DO I=IST,IEND
	  NEW_POPS(:,I)=OLD_POPS(:,I,2)
	END DO
	AV_DONE=.TRUE.
!
	RETURN
	END
