!
! Routine to write out the artificial heating term.
!
	SUBROUTINE WR_COOLING_TERM(dE_COOL,NETCR,TOTCR,COOLING_TERM,
	1                    DESCRIPTER,COUNTER,ND,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
! Created 28-Sep-2004
!
	INTEGER COUNTER
	INTEGER ND
	INTEGER LU
	REAL(KIND=LDP) dE_COOL(ND)
	REAL(KIND=LDP) NETCR(ND)
	REAL(KIND=LDP) TOTCR(ND)
	LOGICAL COOLING_TERM	!Indicates whether term is a heating or cooling term.
	CHARACTER(LEN=*) DESCRIPTER
!
	REAL(KIND=LDP) T1
	INTEGER MS,MF,I
!
	MS=(COUNTER-1)*10+1	
	MF=COUNTER*10
	IF(MF .GT. ND)MF=ND
!
	T1=SUM(dE_COOL)
	IF(T1 .EQ. 0.0_LDP)RETURN
!
	IF(COOLING_TERM)THEN
	  DO I=MS,MF
	    NETCR(I)=NETCR(I)+dE_COOL(I)
	    TOTCR(I)=TOTCR(I)+ABS(dE_COOL(I))
	  END DO
	ELSE
	  DO I=MS,MF
	    NETCR(I)=NETCR(I)-dE_COOL(I)
	    TOTCR(I)=TOTCR(I)+ABS(dE_COOL(I))
	  END DO
	END IF
	WRITE(LU,'(/3X,A)')TRIM(DESCRIPTER)//' [ergs/cm**3/sec]'
	WRITE(LU,999)(dE_COOL(I),I=MS,MF)
C
999	FORMAT(1X,1P,10E12.4)
	RETURN
	END
