C
C Routine returns the K Shell photionization cross section for C,N and O
C ions, From Daltabuit and Cox, 1972, ApJ, 177, 855
C
C FREQ     : 10^15 Hz
C XCROSS   : Returned cross section in units of 10^-10 cm^2
C ZCORE    : Charge of nucleus.
C NUM_ELEC : Number of electrons in system that is being photionized.
C
	FUNCTION XCROSS(FREQ,ZCORE,NUM_ELEC)
	USE SET_KIND_MODULE
	IMPLICIT NONE
C
C Altered 17-Oct-2000 : ZCORE_SAVE introduced to limit number of error
C                          messages.
C Altered 02-Jul-1998 : No error message output for H and He
C                       LUER and ERROR_LU installed.
C
	REAL(KIND=LDP) XCROSS,FREQ,ZCORE,NUM_ELEC
C
	INTEGER LUER,ERROR_LU
	EXTERNAL ERROR_LU
C
C Local variables.
C
	INTEGER J
	REAL(KIND=LDP) U,CON_FAC
C
	LOGICAL ZCORE_SAVE(92)
	SAVE ZCORE_SAVE
	DATA ZCORE_SAVE/92*.FALSE./
C
C
C
C Data variables. C, N, AND O
C
	REAL(KIND=LDP) SIG_C(6),SIG_N(7),SIG_O(8)
	REAL(KIND=LDP) EDGE_C(6),EDGE_N(7),EDGE_O(8)
	REAL(KIND=LDP) S_C(6),S_N(7),S_O(8)
	REAL(KIND=LDP) ALPHA_C(6),ALPHA_N(7),ALPHA_O(8)
C
	DATA SIG_C/0.194_LDP,0.526_LDP,0.850_LDP,0.930_LDP,0.997_LDP,1.06_LDP/
	DATA SIG_N/0.142_LDP,0.371_LDP,0.595_LDP,0.643_LDP,0.683_LDP,0.717_LDP,0.747_LDP/
	DATA SIG_O/0.109_LDP,0.275_LDP,0.439_LDP,0.470_LDP,0.496_LDP,0.518_LDP,0.537_LDP,0.554_LDP/
C
	DATA EDGE_C/490,392,347,317,296,280/
	DATA EDGE_N/666,552,496,459,432,412,395/
	DATA EDGE_O/870,739,672,627,595,570,550,533/
C
	DATA S_C/2.95_LDP,2.76_LDP,2.51_LDP,2.49_LDP,2.48_LDP,2.47_LDP/
	DATA S_N/2.95_LDP,2.79_LDP,2.57_LDP,2.55_LDP,2.54_LDP,2.54_LDP,2.53_LDP/
	DATA S_O/2.95_LDP,2.81_LDP,2.62_LDP,2.61_LDP,2.60_LDP,2.59_LDP,2.59_LDP,2.58_LDP/
C
	DATA ALPHA_C/1.287_LDP,1.325_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
	DATA ALPHA_N/1.287_LDP,1.314_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
	DATA ALPHA_O/1.287_LDP,1.308_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
C
C 
C
C Cross sections for Ne, Mg, Si, and S
C
	REAL(KIND=LDP) SIG_NE(10),SIG_MG(12),SIG_SI(14),SIG_S(16)
	REAL(KIND=LDP) EDGE_NE(10),EDGE_MG(12),EDGE_SI(14),EDGE_S(16)
	REAL(KIND=LDP) S_NE(10),S_MG(12),S_SI(14),S_S(16)
	REAL(KIND=LDP) ALPHA_NE(10),ALPHA_MG(12),ALPHA_SI(14),ALPHA_S(16)
C
	DATA SIG_NE/0.075_LDP,0.18_LDP,0.267_LDP,0.282_LDP,0.295_LDP,0.305_LDP,0.314_LDP,
	1           0.322_LDP,0.329_LDP,0.336_LDP/
	DATA SIG_MG/0.055_LDP,0.13_LDP,0.179_LDP,0.188_LDP,0.194_LDP,0.200_LDP,0.205_LDP,0.210_LDP,
	1           0.213_LDP,0.217_LDP,0.220_LDP,0.223_LDP/
	DATA SIG_SI/0.044_LDP,0.10_LDP,0.128_LDP,0.134_LDP,0.138_LDP,0.141_LDP,0.144_LDP,0.147_LDP,
	1           0.149_LDP,0.151_LDP,0.153_LDP,0.155_LDP,0.157_LDP,0.158_LDP/
	DATA SIG_S/0.035_LDP,0.08_LDP,0.096_LDP,0.099_LDP,0.102_LDP,0.105_LDP,0.106_LDP,0.108_LDP,
	1           0.110_LDP,0.111_LDP,0.112_LDP,0.113_LDP,0.114_LDP,0.115_LDP,0.116_LDP,0.117_LDP/
C
	DATA EDGE_NE/1360,1195,1100,1050,1000,968,940,916,896,878/
	DATA EDGE_MG/1960,1761,1650,1570,1520,1470,1440,1410,1380,
	1            1360,1340,1320/
	DATA EDGE_SI/2670,2430,2300,2210,2140,2090,2050,2010,1980,
	1            1950,1930,1910,1880,1870/
	DATA EDGE_S/3480,3210,3060,2960,2880,2820,2770,2730,2690,
	1           2660,2630,2600,2580,2560,2540,2520/
C
	DATA S_NE/2.90_LDP,2.95_LDP,2.72_LDP,2.71_LDP,2.70_LDP,2.69_LDP,2.69_LDP,2.68_LDP,2.68_LDP,2.67_LDP/
	DATA S_MG/2.90_LDP,2.90_LDP,2.79_LDP,2.78_LDP,2.78_LDP,2.77_LDP,2.77_LDP,2.76_LDP,2.76_LDP,
	1         2.76_LDP,2.75_LDP,2.75_LDP/
	DATA S_SI/2.90_LDP,3.00_LDP,2.86_LDP,2.85_LDP,2.85_LDP,2.84_LDP,2.84_LDP,2.83_LDP,2.83_LDP,2.83_LDP,
	1         2.82_LDP,2.82_LDP,2.82_LDP,2.82_LDP/
	DATA S_S/2.90_LDP,3.00_LDP,2.92_LDP,2.91_LDP,2.91_LDP,2.90_LDP,2.90_LDP,2.89_LDP,2.89_LDP,2.89_LDP,
	1        2.89_LDP,2.88_LDP,2.88_LDP,2.88_LDP,2.88_LDP,2.88_LDP/
C
	DATA ALPHA_NE/1.25_LDP,1.28_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
	DATA ALPHA_MG/1.22_LDP,1.25_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,
	1             1.0_LDP,1.0_LDP/
	DATA ALPHA_SI/1.20_LDP,1.20_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,
	1             1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
	DATA ALPHA_S/1.19_LDP,1.20_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,
	1             1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP,1.0_LDP/
C
C 
C
	CON_FAC=1.0_LDP/0.24191_LDP			!10^15 Hz to ev
	XCROSS=0.0_LDP
	IF(ZCORE .EQ. 6.0_LDP)THEN			!Carbon
	  J=NUM_ELEC
	  U=EDGE_C(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_C(J)*(U**S_C(J))*(ALPHA_C(J)+ (1.0_LDP-ALPHA_C(J))*U )
	ELSE IF(ZCORE .EQ. 7.0_LDP)THEN 		!Nitrogen
	  J=NUM_ELEC
	  U=EDGE_N(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_N(J)*(U**S_N(J))*(ALPHA_N(J)+ (1.0_LDP-ALPHA_N(J))*U )
	ELSE IF(ZCORE .EQ. 8.0_LDP)THEN 		!Oxygen
	  J=NUM_ELEC
	  U=EDGE_O(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_O(J)*(U**S_O(J))*(ALPHA_O(J)+ (1.0_LDP-ALPHA_O(J))*U )
	ELSE IF(ZCORE .EQ. 10.0_LDP)THEN 		!Neon
	  J=NUM_ELEC
	  U=EDGE_NE(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_NE(J)*(U**S_NE(J))*(ALPHA_NE(J)+ (1.0_LDP-ALPHA_NE(J))*U )
	ELSE IF(ZCORE .EQ. 12.0_LDP)THEN 		!Magnesium
	  J=NUM_ELEC
	  U=EDGE_MG(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_MG(J)*(U**S_MG(J))*(ALPHA_MG(J)+ (1.0_LDP-ALPHA_MG(J))*U )
	ELSE IF(ZCORE .EQ. 14.0_LDP)THEN 		!Silicon
	  J=NUM_ELEC
	  U=EDGE_SI(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_SI(J)*(U**S_SI(J))*(ALPHA_SI(J)+ (1.0_LDP-ALPHA_SI(J))*U )
	ELSE IF(ZCORE .EQ. 16.0_LDP)THEN 		!Sulpher
	  J=NUM_ELEC
	  U=EDGE_S(J)/(CON_FAC*FREQ)
	  IF(U .GT. 1.0_LDP)RETURN
	  XCROSS=SIG_S(J)*(U**S_S(J))*(ALPHA_S(J)+ (1.0_LDP-ALPHA_S(J))*U )
	ELSE IF(ZCORE .EQ. 1.0_LDP .OR. ZCORE .EQ. 2.0_LDP)THEN
C
C Do nothing for H and He
C
	ELSE
	  IF(.NOT. ZCORE_SAVE(NINT(ZCORE)))THEN
	    ZCORE_SAVE(NINT(ZCORE))=.TRUE.
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Error : This ZCORE not yet implemented in XCROSS'
	    WRITE(LUER,*)'ZCORE=',ZCORE
	  END IF
	END IF
C
	XCROSS=XCROSS*1.0E-08_LDP
C
	RETURN
	END

