	SUBROUTINE READ_CHI_DATA_FILE(FILE_NAME,ETA_CMF,FREQ_CMF,READ_FREQ,NCF,ND,LUIN,CONT_REC)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
!
! Created 26-Apr-2020
!
	INTEGER NCF
	INTEGER ND
	INTEGER LUIN
	INTEGER CONT_REC
!
	REAL(KIND=LDP) ETA_CMF(ND,NCF)
	REAL(KIND=LDP) FREQ_CMF(NCF)
!
	CHARACTER(LEN=*) FILE_NAME
	LOGICAL READ_FREQ
!
	REAL(KIND=LDP) T1
	INTEGER I,K,ML
	INTEGER INIT_REC
	INTEGER IOS
	INTEGER REC_LENGTH
	INTEGER NCF_RD
	INTEGER ND_RD
	CHARACTER(LEN=11) FILE_DATE
	INTEGER ERROR_LU
	EXTERNAL ERROR_LU
!
	WRITE(6,*)TRIM(FILE_NAME);FLUSH(UNIT=6)
	CALL READ_DIRECT_INFO_V3(I,REC_LENGTH,FILE_DATE,FILE_NAME,LUIN,IOS)
	IF(IOS .NE. 0)THEN
	  WRITE(I,*)'Error reading ',TRIM(FILE_NAME)//'_INFO','in READ_CHI_DATA_FILE'
	  STOP
	END IF
	OPEN(UNIT=LUIN,FILE=FILE_NAME,STATUS='OLD',RECL=REC_LENGTH,
	1                ACCESS='DIRECT',FORM='UNFORMATTED',ACTION='READ')
	READ(LUIN,REC=CONT_REC)INIT_REC,NCF_RD,ND_RD
!
	I=ERROR_LU()
	IF(ND_RD .NE. ND)THEN
	  WRITE(I,*)'Error reading',TRIM(FILE_NAME),'in READ_2D_OBS_FILe'
	  WRITE(I,*)'ND and ND_RD must agree'
	  WRITE(I,*)'ND=',ND,'ND_RD=',ND_RD
	  STOP
	END IF
	IF(NCF_RD .NE. NCF)THEN
	  WRITE(I,*)'Error reading',TRIM(FILE_NAME),'in READ_2D_OBS_FILe'
	  WRITE(I,*)'NCF and NCF_RD must agree'
	  WRITE(I,*)'NCF=',NCF,'NCF_RD=',NCF_RD
	  STOP
	END IF
!
	DO ML=1,NCF
	  READ(LUIN,REC=INIT_REC+ML-1)(ETA_CMF(K,ML),K=1,ND),T1
	  IF(READ_FREQ)THEN
	    FREQ_CMF(ML)=T1
	  ELSE IF(T1 .NE. FREQ_CMF(ML))THEN
	    WRITE(6,*)'Error in READ_CHI_DATA_FILE - ',TRIM(FILE_NAME)
	    WRITE(6,*)'Inconsistent frequency grid'
	    WRITE(6,*)T1,FREQ_CMF(ML)
	    STOP
	  END IF
	END DO
!
	RETURN
	END
