!
! Set of subroutines that allow a modification of KEY WORD values
! in a CMFGEN input files. An example is an update of
! XFI1_BEG etc which change as the iteration procedes.
!
! Altered 13-Nov-2017: Fixed minor bug with update_keyowrd_dp
! Altered 10-Jun-2015: PRIVATE made default for UPDATE_KEYWORD_INTERFACE
! Altered 10-Jun-2015: Subroutine cause gracefull stop if KEYWORD file cannot be opened.
! Altered 09-May-2014: LUER was not set before being used in several locations.
! Created 23-Nov-2007
!
	MODULE UPDATE_KEYWORD_INTERFACE
	INTEGER, PRIVATE, PARAMETER :: MAX_RECS=800
	INTEGER, PRIVATE, SAVE :: NUM_RECS=0
	CHARACTER(LEN=80), PRIVATE, ALLOCATABLE :: STORE(:)
	CHARACTER(LEN=20) PRIVATE, TMP_STR
	INTERFACE UPDATE_KEYWORD
          MODULE PROCEDURE UPDATE_KEYWORD_DP,
	1                  UPDATE_KEYWORD_LOG,
	1                  UPDATE_KEYWORD_INT,
	1                  UPDATE_KEYWORD_STR
        END INTERFACE
        CONTAINS
!
!
!
	SUBROUTINE UPDATE_KEYWORD_DP(VALUE,KEY_WORD,DATA_FILE,RD_FILE,WR_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	REAL(KIND=LDP) VALUE
	CHARACTER(LEN=*) KEY_WORD
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL RD_FILE
	LOGICAL WR_FILE
	INTEGER LU,LUER,ERROR_LU
	EXTERNAL ERROR_LU
	INTEGER I,J,K,ID
!
	CALL RD_KEY_WRD_FILE(DATA_FILE,RD_FILE,LU)
!
	DO I=1,NUM_RECS
	  K=INDEX(STORE(I),KEY_WORD)
	  IF(K .NE. 0)THEN
	    IF(ABS(VALUE) .GT. 0.01_LDP .AND. ABS(VALUE) .LT. 1.0E+05_LDP)THEN
	      IF(TMP_STR .EQ. '[RMAX]' .OR. TMP_STR .EQ. '[RSTAR]')THEN
	        WRITE(TMP_STR,'(F23.11)')VALUE
	      ELSE
	        WRITE(TMP_STR,'(F20.8)')VALUE
	      END IF
	      TMP_STR=ADJUSTL(TMP_STR)
	      J=LEN_TRIM(TMP_STR)
	    ELSE
	      WRITE(TMP_STR,'(ES20.8)')VALUE
	      TMP_STR=ADJUSTL(TMP_STR)
	      J=INDEX(TMP_STR,'E')
	      TMP_STR(J:J)='D'
	      J=J-1
	    END IF
	    ID=INDEX(TMP_STR,'.')+1
	    DO WHILE(J .GT. ID)
	      IF(TMP_STR(J:J) .NE. '0')EXIT
	      TMP_STR(J:)=TMP_STR(J+1:)
	      J=J-1
	    END DO
	    J=LEN_TRIM(TMP_STR)
	    IF(J .LT. K-2)THEN
	       STORE(I)(1:K-1)=' '
	       STORE(I)(1:J)=TRIM(TMP_STR)
	    ELSE
	       STORE(I)=TMP_STR(1:J)//'  '//STORE(I)(K:)
	    END IF
	    EXIT
	  END IF
	END DO
	IF(K .EQ. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error in UPDATE_KEYWORD'
	  WRITE(LUER,*)TRIM(KEY_WORD),' not found in file ',TRIM(DATA_FILE)
	  STOP
	END IF
!
	CALL WR_KEY_WRD_FILE(DATA_FILE,WR_FILE,LU)
!
	END SUBROUTINE UPDATE_KEYWORD_DP
!
!
	SUBROUTINE UPDATE_KEYWORD_LOG(VALUE,KEY_WORD,DATA_FILE,RD_FILE,WR_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	LOGICAL VALUE
	CHARACTER(LEN=*) KEY_WORD
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL RD_FILE
	LOGICAL WR_FILE
	INTEGER LU,LUER,ERROR_LU
	EXTERNAL ERROR_LU
	INTEGER I,K
!
	CALL RD_KEY_WRD_FILE(DATA_FILE,RD_FILE,LU)
!
	DO I=1,NUM_RECS
	  K=INDEX(STORE(I),KEY_WORD)
	  IF(K .NE. 0)THEN
	    STORE(I)(1:K-1)=' '
	    STORE(I)(1:1)='F'
	    IF(VALUE)STORE(I)(1:1)='T'
	    EXIT
	  END IF
	END DO
!
	IF(K .EQ. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error in UPDATE_KEYWORD'
	  WRITE(LUER,*)TRIM(KEY_WORD),' not found in file ',TRIM(DATA_FILE)
	  STOP
	END IF
!
	CALL WR_KEY_WRD_FILE(DATA_FILE,WR_FILE,LU)
!
	END SUBROUTINE UPDATE_KEYWORD_LOG
!
!
	SUBROUTINE UPDATE_KEYWORD_INT(VALUE,KEY_WORD,DATA_FILE,RD_FILE,WR_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	INTEGER VALUE
	CHARACTER(LEN=*) KEY_WORD
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL RD_FILE
	LOGICAL WR_FILE
	INTEGER LU,LUER,ERROR_LU
	EXTERNAL ERROR_LU
	INTEGER I,J,K
!
	CALL RD_KEY_WRD_FILE(DATA_FILE,RD_FILE,LU)
!
	DO I=1,NUM_RECS
	  K=INDEX(STORE(I),KEY_WORD)
	  IF(K .NE. 0)THEN
	    WRITE(TMP_STR,'(I20)')VALUE
	    TMP_STR=ADJUSTL(TMP_STR)
	    J=LEN_TRIM(TMP_STR)
	    IF(J .LT. K-2)THEN
	       STORE(I)(1:K-1)=' '
	       STORE(I)(1:J)=TRIM(TMP_STR)
	    ELSE
	       STORE(I)=TMP_STR(1:J)//'  '//STORE(I)(K:)
	    END IF
	    EXIT
	  END IF
	END DO
!
	IF(K .EQ. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error in UPDATE_KEYWORD'
	  WRITE(LUER,*)TRIM(KEY_WORD),' not found in file ',TRIM(DATA_FILE)
	  STOP
	END IF
!
	CALL WR_KEY_WRD_FILE(DATA_FILE,WR_FILE,LU)
!
	END SUBROUTINE UPDATE_KEYWORD_INT
!
!
	SUBROUTINE UPDATE_KEYWORD_STR(VALUE,KEY_WORD,DATA_FILE,RD_FILE,WR_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
!
	CHARACTER(LEN=*) VALUE
	CHARACTER(LEN=*) KEY_WORD
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL RD_FILE
	LOGICAL WR_FILE
	INTEGER LU,LUER,ERROR_LU
	EXTERNAL ERROR_LU
	INTEGER I,J,K
!
	CALL RD_KEY_WRD_FILE(DATA_FILE,RD_FILE,LU)
!
	DO I=1,NUM_RECS
	  K=INDEX(STORE(I),KEY_WORD)
	  IF(K .NE. 0)THEN
	    J=LEN_TRIM(VALUE)
	    IF(J .LT. K-2)THEN
	       STORE(I)(1:K-1)=' '
	       STORE(I)(1:J)=TRIM(VALUE)
	    ELSE
	       STORE(I)=VALUE(1:J)//'  '//STORE(I)(K:)
	    END IF
	    EXIT
	  END IF
	END DO
!
	IF(K .EQ. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'Error in UPDATE_KEYWORD'
	  WRITE(LUER,*)TRIM(KEY_WORD),' not found in file ',TRIM(DATA_FILE)
	  STOP
	END IF
!
	CALL WR_KEY_WRD_FILE(DATA_FILE,WR_FILE,LU)
!
	END SUBROUTINE UPDATE_KEYWORD_STR
!
!
!
	SUBROUTINE WR_KEY_WRD_FILE(DATA_FILE,WR_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL WR_FILE
	INTEGER LU
	INTEGER I
!
	IF(WR_FILE)THEN
	  OPEN(UNIT=LU,FILE=TRIM(DATA_FILE),ACTION='WRITE')
	    DO I=1,NUM_RECS
	       WRITE(LU,'(A)')TRIM(STORE(I))
	    END DO
	  CLOSE(LU)
	  DEALLOCATE (STORE)
	END IF
!
	END SUBROUTINE WR_KEY_WRD_FILE
!
!
!
	SUBROUTINE RD_KEY_WRD_FILE(DATA_FILE,RD_FILE,LU)
	USE SET_KIND_MODULE
	IMPLICIT NONE
	CHARACTER(LEN=*) DATA_FILE
	LOGICAL RD_FILE
	INTEGER LU,LUER,ERROR_LU
	EXTERNAL ERROR_LU
	INTEGER I,IOS
!
	IF(RD_FILE)THEN
	  LUER=ERROR_LU()
	  ALLOCATE (STORE(MAX_RECS))
	  OPEN(UNIT=LU,FILE=TRIM(DATA_FILE),ACTION='READ',IOSTAT=IOS)
	    IF(IOS .NE. 0)THEN
	      WRITE(LUER,*)'Error opening ',TRIM(DATA_FILE),' in RD_KEY_WRD_FILE'
	      WRITE(LUER,*)'IOS=',IOS
	      STOP
	    END IF
	    DO I=1,MAX_RECS
	       READ(LU,'(A)',END=100)STORE(I)
	       NUM_RECS=I
	    END DO
	    READ(LU,'(A)',END=100)TMP_STR
	    LUER=ERROR_LU()
	    WRITE(LUER,*)'Insufficient storage in UPDATE_KEYWORD'
	    WRITE(LUER,*)'Keyword data file is:',TRIM(DATA_FILE)
	    STOP
100	    CONTINUE
	  CLOSE(LU)
	END IF
!
	IF(NUM_RECS .EQ. 0)THEN
	  LUER=ERROR_LU()
	  WRITE(LUER,*)'No data file with keywords has been opened in UPDATE_KEYWORD'
	  STOP
	END IF
!
	RETURN
	END SUBROUTINE RD_KEY_WRD_FILE
!
	END MODULE UPDATE_KEYWORD_INTERFACE
